#!/bin/bash

# Caminho do arquivo .zip montado no contêiner
ZIP_SOURCE="/webapps.zip"

# Diretório de destino montado pelo volume
DESTINATION="/usr/local/tomee/webapps"

# Verifica se o volume está montado corretamente
if [ ! -d "$DESTINATION" ]; then
    echo "Erro: Diretório de destino $DESTINATION não encontrado."
    exit 1
fi

# Verifica se o arquivo zip está disponível
if [ -f "$ZIP_SOURCE" ]; then
    echo "Arquivo webapps.zip encontrado. Preparando para descompactar..."
else
    echo "Erro: Arquivo webapps.zip não encontrado. Certifique-se de que está na raiz do docker-compose."
    exit 1
fi

# Instala o unzip se não estiver disponível
if ! command -v unzip &> /dev/null; then
    echo "Unzip não encontrado. Instalando..."
    apt-get update && apt-get install -y unzip && apt-get clean
fi

# Descompacta os arquivos no diretório montado somente se estiver vazio
if [ ! "$(ls -A $DESTINATION)" ]; then
    echo "Diretório de destino está vazio. Extraindo arquivos do webapps.zip para a raiz do volume..."
    unzip -o "$ZIP_SOURCE" -d "$DESTINATION"
    mv "$DESTINATION/webapps/"* "$DESTINATION/" 2>/dev/null || true
    rm -rf "$DESTINATION/webapps"
    echo "Arquivos extraídos com sucesso para $DESTINATION."
else
    echo "O volume já contém arquivos. Nenhuma extração necessária."
fi

# Inicia o TomEE
echo "Iniciando o Apache TomEE..."
exec catalina.sh run
