--TEST--
MongoDB\Driver\ClientEncryption::encrypt() BSON encoding errors
--SKIPIF--
<?php require __DIR__ . "/../utils/basic-skipif.inc"; ?>
<?php skip_if_not_libmongocrypt(); ?>
--FILE--
<?php

require_once __DIR__ . "/../utils/basic.inc";

$manager = create_test_manager();

$clientEncryption = $manager->createClientEncryption([
    'keyVaultNamespace' => CSFLE_KEY_VAULT_NS,
    'kmsProviders' => ['local' => ['key' => new MongoDB\BSON\Binary(CSFLE_LOCAL_KEY, 0)]],
    'encryptedFieldsMap' => [
        NS => [
            'fields' => [
                'path' => 'encryptedInt',
                'bsonType' => 'int',
                'queries' => [
                    'queryType' => 'rangePreview',
                    'contention' => 0,
                    'sparsity' => 1,
                    'min' => 0,
                    'max' => 200,
                ],
            ],
        ],
    ],
]);

$keyId = $clientEncryption->createDataKey('local');

$r = $clientEncryption->encryptExpression(['foo'], [
    'keyId' => $keyId,
    'algorithm' => ClientEncryption::ALGORITHM_RANGE_PREVIEW,
]);

var_dump($r);

?>
===DONE===
<?php exit(0); ?>
--EXPECTF--

===DONE===
