# Evolution API

## What is Evolution API?
Evolution API is a multi-instance WhatsApp API designed to enable developers to integrate and manage WhatsApp sessions programmatically. It provides a simple and scalable way to send and receive messages, manage contacts, handle QR logins, and automate communication flows — all via RESTful endpoints.

---

## ⚙️ Key Features
- **Multi-Instance Management**: Create and manage multiple WhatsApp sessions (useful for SaaS or multi-client setups).  
- **QR Code Authentication**: Connect WhatsApp accounts by scanning a generated QR code.  
- **Message Handling**: Send, receive, and read messages in real time.  
- **Webhook Support**: Get updates instantly when messages or events occur.  
- **Media Uploads**: Send images, videos, documents, and audio through endpoints.  
- **Session Persistence**: Keeps your WhatsApp sessions active even after server restarts (via persistent storage).  
- **Security**: Supports authentication tokens for secure API usage.  

---

## 🧱 Architecture
The API runs inside a **Docker container**, making deployment simple and isolated.


## Resources and Documentation
- [Official Evolution API Site](https://evoapicloud.com/)
- [Documentation and Support](https://doc.evolution-api.com/)
- [Repository](https://github.com/EvolutionAPI/evolution-api)